/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import reliquary.init.RandomChanceLootingSeveringCondition;
import reliquary.reference.Settings;

public class ModLoot {
    private static final List<String> CHEST_TABLES = List.of("abandoned_mineshaft", "desert_pyramid", "end_city_treasure", "igloo_chest", "jungle_temple", "nether_bridge", "simple_dungeon", "stronghold_corridor", "stronghold_crossing", "stronghold_library", "village_blacksmith");
    private static final List<String> ENTITY_TABLES = List.of("bat", "blaze", "cave_spider", "creeper", "enderman", "ghast", "guardian", "husk", "magma_cube", "skeleton", "slime", "snow_golem", "spider", "stray", "squid", "witch", "wither_skeleton", "zombie", "zombified_piglin", "zombie_villager");

    private ModLoot() {
    }

    public static void registerListeners(IEventBus modBus) {
        modBus.addGenericListener(GlobalLootModifierSerializer.class, ModLoot::registerLootData);
    }

    public static void registerEventBusListeners(IEventBus eventBus) {
        eventBus.addListener(ModLoot::lootLoad);
    }

    private static void lootLoad(LootTableLoadEvent evt) {
        String chestsPrefix = "minecraft:chests/";
        String entitiesPrefix = "minecraft:entities/";
        String name = evt.getName().toString();
        if (((Boolean)Settings.COMMON.chestLootEnabled.get()).booleanValue() && name.startsWith(chestsPrefix) && CHEST_TABLES.contains(name.substring(chestsPrefix.length())) || ((Boolean)Settings.COMMON.mobDropsEnabled.get()).booleanValue() && name.startsWith(entitiesPrefix) && ENTITY_TABLES.contains(name.substring(entitiesPrefix.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(ModLoot.getInjectPool(file));
        }
    }

    private static void registerLootData(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("reliquary", "random_chance_looting_severing"), (Object)RandomChanceLootingSeveringCondition.LOOT_CONDITION_TYPE);
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.m_79043_().m_79076_(ModLoot.getInjectEntry(entryName)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("reliquary_inject_pool").m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name) {
        return LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("reliquary", "inject/" + name)).m_79707_(1);
    }
}

